package ru.yandex.tours.tools

import java.io.File

import akka.actor.ActorSystem
import ru.yandex.tours.avatars.HttpAvatarClient
import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.model.image.ImageProviders
import ru.yandex.tours.util.http.NingHttpClient

import scala.collection.JavaConversions._
import scala.concurrent.Await
import scala.concurrent.duration._

object ImageSetter extends App {
  val as = ActorSystem()
  implicit val ec = as.dispatcher
  val httpClient = new NingHttpClient(None)(as.dispatcher)
  val avatarsClient = new HttpAvatarClient(httpClient, "http://avatars-int.mdst.yandex.net:13000", "//avatars.mdst.yandex.net", "tours")

  var cnt = 0
  val hotels = HotelIO.loadFromFile(new File("lt.hotels.proto")).map(hotel => {
    cnt += 1
    if (cnt % 100 == 0) {
      println(s"$cnt done")
    }
    updateHotel(hotel)
  })

  HotelIO.dumpToFile(hotels, "lt.with.images.proto")

  println("Success!!")
  private def updateHotel(hotel: Hotel) = {
    val images = hotel.getPhotosList.filter(_.nonEmpty).map(url => avatarsClient.put(url, ImageProviders.lt).map(_.toProto))
    val future = ru.yandex.tours.util.lang.notFailedResults(images)
    val x = Await.result(future, 100.seconds)
    hotel.toBuilder.addAllImages(asJavaIterable(x)).build()
  }
}
