package ru.yandex.tours.tools

import java.io.{ByteArrayInputStream, PrintWriter}
import java.util.UUID

import org.apache.hadoop.hbase.TableName
import org.apache.hadoop.hbase.client.ConnectionFactory
import org.joda.time.DateTime
import ru.yandex.tours.model.search.SearchProducts.Offer
import ru.yandex.tours.model.search.SearchResults.{ActualizedOffer, ResultInfo}
import ru.yandex.tours.model.utm.UtmMark
import ru.yandex.tours.personalization.UserIdentifiers
import ru.yandex.tours.util.{IO, LabelBuilder, ProtoIO}
import spray.http.Uri

import scala.collection.JavaConverters._
import scala.util.Try

object InnaUrlParser extends HBaseTool {

  val connection = ConnectionFactory.createConnection(bruny)
  val table = connection.getTable(TableName.valueOf("tours-tours-ru-search"))

  IO.using(
    getScanner(table, new DateTime(2015, 12, 1, 0, 0), DateTime.now()),
    new PrintWriter("inna_urls")
  ) { (scanner, out) =>
    for (row <- scanner.iterator.asScala) {
      val offerArray = row.compressedBytes("tours")
      for {
        offers <- Try(ProtoIO.loadFromStream(new ByteArrayInputStream(offerArray), Offer.PARSER).toVector).toOption.toIterable
        offer <- offers
        if offer.getSource.getOperatorId == 9 && offer.getSource.getPartnerId == 5
        url = offer.getAgentBookingUrl
      } {
        val ao: ActualizedOffer = ActualizedOffer.newBuilder().setOffer(offer).setResultInfo(ResultInfo.newBuilder().setIsFromLongCache(false)).build
        val utmHolder = UtmMark.empty.copy(source = "wizard", query = UUID.randomUUID().toString)
        val userIdentifiers = UserIdentifiers(Some("asd"), Some("psd"), Some(UUID.randomUUID().toString))
        val labelBuilder = new LabelBuilder("testtesttesttest")
        val label = labelBuilder.build(ao, utmHolder, userIdentifiers)
        val uri = Uri(url)
        val resultUrl = uri.withQuery(("label", label) +: uri.query)
        out.println(resultUrl)
      }

    }
  }
}