package ru.yandex.tours.tools

import java.io.PrintWriter

import ru.yandex.tours.util.parsing.Tabbed
import ru.yandex.tours.util.Collections._

import scala.collection.mutable

object MappingChecker extends App {

  val ostrovok2expedia = scala.io.Source.fromFile("ostrovok_2_expedia.tsv").getLines().map {
    case Tabbed(ostrovok, booking) => ostrovok -> booking
  }.toMap

  println("Multiple ostrovok to expedia: " + (ostrovok2expedia.values.toSet.size != ostrovok2expedia.keySet.size))

  val ostrovok2booking = scala.io.Source.fromFile("ostrovok_2_booking.tsv").getLines().map {
    case Tabbed(ostrovok, booking) => ostrovok -> booking
  }.toMap

  println("Multiple ostrovok to booking: " + (ostrovok2booking.values.toSet.size != ostrovok2booking.keySet.size))


  val oktogo2booking = mutable.HashMap.empty[String, String]
  val oktogo2expedia = mutable.HashMap.empty[String, String]

  scala.io.Source.fromFile("oktogo.mappings.tsv").getLines().foreach {
    case Tabbed(oktogoId, booking, expedia, url) =>
      if (booking != "") oktogo2booking.put(oktogoId, booking)
      if (expedia != "") oktogo2expedia.put(oktogoId, expedia)
  }

  println("Multiple oktogo to expedia: " + (oktogo2expedia.values.toSet.size != oktogo2expedia.keySet.size))

  println("Multiple oktogo to booking: " + (oktogo2booking.values.toSet.size != oktogo2booking.keySet.size))

  val expediaIds = (oktogo2expedia.values ++ ostrovok2expedia.values).toSet
  val expedia2oktogo = oktogo2expedia.toMap.swapKV
  val expedia2ostrovok = ostrovok2expedia.swapKV
  
  val expediaConflicts = new PrintWriter("expedia_conflicts.tsv")
  expediaConflicts.println("expedia_id\toktogo_id\toktogo_booking_id\tostrovok_id\tostrovok_booking_id")

  val expediaConflictsCount = expediaIds.count(expediaId => {
    (expedia2oktogo.get(expediaId).flatMap(oktogo2booking.get), expedia2ostrovok.get(expediaId).flatMap(ostrovok2booking.get)) match {
      case (Some(book1), Some(book2)) =>
        if (book1 != book2) {
          expediaConflicts.println(Seq(expediaId, expedia2oktogo(expediaId), book1, expedia2ostrovok(expediaId), book2).mkString("\t"))
        }
        book1 != book2
      case _ => false
    }
  })
  println("Conflicts through expedia: " + expediaConflictsCount)
  expediaConflicts.close()

  val booking2oktogo = oktogo2booking.toMap.swapKV
  val booking2ostrovok = ostrovok2booking.swapKV
  
  val bookingIds = booking2oktogo.keySet ++ booking2ostrovok.keySet
  val bookingConflicts = new PrintWriter("booking_conflicts.tsv")
  bookingConflicts.println("booking_id\toktogo_id\toktogo_expedia_id\tostrovok_id\tostrovok_expedia_id")

  val bookingConflictsCount = bookingIds.count(bookingId => {
    (booking2oktogo.get(bookingId).flatMap(oktogo2expedia.get), booking2ostrovok.get(bookingId).flatMap(ostrovok2expedia.get)) match {
      case (Some(book1), Some(book2)) =>
        if (book1 != book2) {
          bookingConflicts.println(Seq(bookingId, booking2oktogo(bookingId), book1, booking2ostrovok(bookingId), book2).mkString("\t"))
        }
        book1 != book2
      case _ => false
    }
  })

  println("Conflicts through booking: " + bookingConflictsCount)
  bookingConflicts.close()


  val expediaMatching = new PrintWriter("expedia_matching.tsv")
  expediaMatching.println("expedia_id\toktogo_id\tostrovok_id")
  (expedia2oktogo.keySet & expedia2ostrovok.keySet).foreach { expedia =>
    (expedia2oktogo.get(expedia).flatMap(oktogo2booking.get), expedia2ostrovok.get(expedia).flatMap(ostrovok2booking.get)) match {
      case (Some(book1), Some(book2)) if book1 == book2 => // nope
      case _ => expediaMatching.println(Seq(expedia, expedia2oktogo(expedia), expedia2ostrovok(expedia)).mkString("\t"))
    }
  }
  expediaMatching.close()

}
