package ru.yandex.tours.tools

import java.io.{FileOutputStream, File}

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.{Partners, HotelsHolder}
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.mutable

object MergeOnMappings extends Tool {
  // expediaId -> oktogoId, oktogoUrl
  val expedia2oktogo = mutable.HashMap.empty[String, (String, String)]
  // bookingId -> oktogoId, oktogoUrl
  val booking2oktogo = mutable.HashMap.empty[String, (String, String)]
  scala.io.Source.fromFile("oktogo.mappings.tsv").getLines().foreach {
    case Tabbed(oktogoId, booking, expedia, url) =>
      if (booking != "") booking2oktogo.put(booking, (oktogoId, url))
      if (expedia != "") expedia2oktogo.put(expedia, (oktogoId, url))
  }

  val ostrovok2expedia = scala.io.Source.fromFile("ostrovok_2_expedia.tsv").getLines().map {
    case Tabbed(ostrovok, expedia) => ostrovok -> expedia
  }.toMap

  val ostrovok2booking = scala.io.Source.fromFile("ostrovok_2_booking.tsv").getLines().map {
    case Tabbed(ostrovok, booking) => ostrovok -> booking
  }.toMap


  private def buildOktogoHotel(parent: HotelsHolder.Hotel, oktogoId: String, oktogoUrl: String) = {
    HotelsHolder.Hotel.newBuilder()
      .setGeoId(parent.getGeoId)
      .setId(0)
      .setPoint(parent.getPoint)
      .setLocalId(oktogoId)
      .setPartnerId(Partners.oktogo.id)
      .setPartnerUrl(oktogoUrl)
      .build
  }
  val addedOktogo = mutable.HashSet.empty[String]

  val bookingWithOktogo = HotelIO.loadFromFileAsIterator(new File("booking.hotels.proto")).map { hotel =>
    val builder = hotel.toBuilder
    booking2oktogo.get(hotel.getLocalId) match {
      case Some((oktogoId, oktogoUrl)) =>
        addedOktogo += oktogoId
        val child = buildOktogoHotel(hotel, oktogoId, oktogoUrl)
        builder.addChildren(child)
      case None =>
    }
    builder.build()
  }.map(h => h.getLocalId -> h).toMap

  println("Total booking size: " + bookingWithOktogo.size)
  var mergedBooking = mutable.HashSet.empty[String]

  val finalHotels = HotelIO.loadFromFileAsIterator(new File("ostrovok.hotels.proto")).map { hotel =>
    val ostrovokBuilder = hotel.toBuilder
    ostrovok2booking.get(hotel.getLocalId).flatMap(bookingWithOktogo.get).foreach { bookingHotel =>
      mergedBooking += bookingHotel.getLocalId
      val bookingBuilder = bookingHotel.toBuilder
      ostrovokBuilder.addAllChildren(bookingBuilder.getChildrenList)
      bookingBuilder.clearChildren()
      ostrovokBuilder.addChildren(bookingBuilder)
    }
    for {
      expedia <- ostrovok2expedia.get(hotel.getLocalId)
      (oktogoId, oktogoUrl) <- expedia2oktogo.get(expedia)
      if !addedOktogo.contains(oktogoId)
    } {
      addedOktogo += oktogoId
      ostrovokBuilder.addChildren(buildOktogoHotel(hotel, oktogoId, oktogoUrl))
    }
    ostrovokBuilder.build
  }




  val os = new FileOutputStream("final.hotel.proto")
  for (hotel <- finalHotels) {
    hotel.writeDelimitedTo(os)
  }
  val uniqueBookingHotels = bookingWithOktogo.values.filter(h => !mergedBooking.contains(h.getLocalId))
  for (hotel <- uniqueBookingHotels) {
    hotel.writeDelimitedTo(os)
  }
  os.close()

  println("Added booking: " + mergedBooking.size)
  println("Standalone booking: " + uniqueBookingHotels.size)
}
