package ru.yandex.tours.tools

import java.io.PrintWriter

import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{DoubleValue, IntValue, Tabbed}

object MergingToolInterpreter extends App {
  val pw = new PrintWriter("same.merging.tsv")

  IO.readLines("lt_merging.tsv").foreach {
    case Tabbed(IntValue(5), ltId, partnerId, partnerHotel, DoubleValue(nameDist), DoubleValue(geoDist)) =>
      if (nameDist < 1e-5 && geoDist < 0.5) {
        pw.println(Seq(5, ltId, partnerId, partnerHotel).mkString("\t"))
      }
  }
  pw.close()
}
