package ru.yandex.tours.tools

import java.io.PrintWriter

import models.DbPartnerHotel
import ru.yandex.tours.app.{AkkaSupport, Application, DefaultEnvironment}
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.hotels.{Hotel, Partners}
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.JavaConversions._

/**
  * Created by asoboll on 25.07.16.
  */
object OnePartnerHotelsExport extends Application with DefaultEnvironment with AkkaSupport with ToolDataHolders with TestDb {

  val partner = Partners.hotelsCombined

  val exportFile = "HC_hotels.tsv"

  val db = testDb

  val hotelsDao = new HotelsDao(db)

  val hotelQuery = HotelsDao.OnlyPartner(partner)

  def result(pw: PrintWriter) = {

    var counter = 0

    def processHotel(hotel: DbPartnerHotel) = {
      if (counter % 1000 == 0) println(s"processed $counter hotels")
      counter += 1

      val partnerId = hotel.hotel.getRawHotel.getPartnerId
      val clusterId = getIndexId(partner, partnerId)
      val addInfo = hotel.hotel.getRawHotel.getAddInfoList
      val bookingId = addInfo
        .find(ai => ai.getName.equalsIgnoreCase("BookingID"))
        .fold("no BookingID")(feature => getIndexId(Partners.booking, feature.getValue))
      val oktogoId = addInfo
        .find(ai => ai.getName.equalsIgnoreCase("OktogoID"))
        .fold("no OktogoID")(feature => getIndexId(Partners.oktogo, feature.getValue))

      pw.println(Tabbed(
        hotel.id,
        clusterId,
        bookingId,
        oktogoId
      ))
    }

    pw.println("hotel_id\tcluster_id\tclusted_id_by_booking\tclusted_id_by_oktogo")
    hotelsDao.traverse(hotelQuery) { hotel => processHotel(hotel) }
  }

  def getIndexHotel(partner: Partner, id: String): Option[Hotel] = {
    hotelsIndex.getHotel(partner, id)
  }

  def getIndexId(partner: Partner, id: String): String = {
    getIndexHotel(partner, id).fold("not in index")(_.id.toString)
  }

  hotelsIndex // init to avoid deadlock
  IO.usingAsync(new PrintWriter(exportFile)) { pw =>
    result(pw)
  }.onComplete { res =>
    println(res)
    System.exit(0)
  }

}
