package ru.yandex.tours.tools

import ru.yandex.tours.model.Languages
import ru.yandex.tours.util.parsing.TSKV

import scala.collection.mutable
import scala.sys.process._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 14.04.15
 * https://st.yandex-team.ru/HOTELS-399
 */
object PopularityTool extends Tool {

  val lines = "ssh logger01h.vs.yandex.net \"/home/darl/logs.sh\"".lineStream.iterator

  val popularity = new mutable.HashMap[Int, Int]().withDefaultValue(0)

  for {
    line <- lines
    data <- TSKV.unapply(line)
  } {
    val to = data("to").toInt
    popularity(to) += 1
  }

  val mappingTree = new mutable.HashMap[Int, Vector[Int]].withDefaultValue(Vector.empty)

  for {
    (regionId, _) <- popularity
    if !geoMapping.isKnownDestCountry(regionId)
    region <- tree.region(regionId)
    country <- tree.pathToRoot(region).find(r => geoMapping.isKnownDestCountry(r.id))
  } {
    mappingTree(country.id) :+= regionId
  }

  for {
    (countryId, regions) <- mappingTree.toSeq.sortBy(p => -popularity(p._1))
    country <- tree.region(countryId)
  } {
    println(country.name(Languages.ru) + " – " + popularity(countryId))
    for {
      childId <- regions.sortBy(popularity).reverse.take(5)
      region <- tree.region(childId)
    } {
      println("    " + region.name(Languages.ru) + " – " + popularity(childId))
    }
  }
}
