package ru.yandex.tours.tools

import java.io.PrintWriter

import ru.yandex.tours.model.Languages
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.file._
import ru.yandex.tours.util.parsing.{IntValue, DoubleValue, Tabbed}

import scala.collection.mutable
import scala.io.Source

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 11.06.15
 */
object SimilarityConverterTool extends Tool {
  val geoByName = tree.regions.map(r => r.name(Languages.ru) -> r).toMap
  IO.using(new PrintWriter(dataDir / "geo_similarity.tsv")) { out =>
    def process: PartialFunction[String, Unit] = {
      case Tabbed(_, DoubleValue(conf), _, DoubleValue(leverage), _, _, geo1, geo2) =>
        val r1 = geoByName(geo1)
        val r2 = geoByName(geo2)
        if (leverage > 0 && r1.id < r2.id) {
          out.println(Tabbed(r1.id, r2.id, leverage + (conf / 1000)))
        }
    }

    Source.fromFile("util-heavy/python/recommendations/output/countries_recommendations.tsv")
      .getLines().drop(1).foreach(process)

    Source.fromFile("util-heavy/python/recommendations/output/resorts_recommendations.tsv")
      .getLines().drop(1).foreach(process)
  }

  IO.using(new PrintWriter(dataDir / "hotels_similarity.tsv")) { out =>
    def process: PartialFunction[String, Unit] = {
      case Tabbed(_, DoubleValue(conf), _, DoubleValue(leverage), _, _, IntValue(hotel1), IntValue(hotel2), _*) =>
        if (leverage > 0 && hotel1 < hotel2) {
          out.println(Tabbed(hotel1, hotel2, leverage + (conf / 100000)))
        }
    }

    Source.fromFile("util-heavy/python/recommendations/output/hotels_recommendations_apr1_june30_2015_1.tsv")
      .getLines().drop(1).foreach(process)
  }

  val countries = new mutable.HashMap[Int, (Double, Double)]()
  val resorts = new mutable.HashMap[Int, (Double, Double)]()

  //HOTELS-1389
  val countryPopularityLines = Source.fromFile("util-heavy/data/suggest/new_countries_priorities_for_suggest.tsv").getLines().drop(1)
  val resortPopularityLines = Source.fromFile("util-heavy/data/suggest/new_resorts_priorities_for_suggest.tsv").getLines().drop(1)

  countryPopularityLines.foreach {
    case Tabbed(IntValue(geoId), name, _, DoubleValue(roomsRating), DoubleValue(toursRating), _) =>
      countries += (geoId -> (toursRating, roomsRating))
  }

  resortPopularityLines.foreach {
    case Tabbed(IntValue(geoId), name, _, DoubleValue(toursRating), DoubleValue(roomsRating), _*) =>
      resorts += (geoId -> (toursRating, roomsRating))
  }

  IO.using(new PrintWriter(dataDir / "direction_stats.tsv")) { out =>
    for ((country, (toursRating, roomsRating)) <- countries) {
      out.println(Tabbed(country, toursRating, roomsRating))
    }

    for ((resort, (toursRating, roomsRating)) <- resorts) {
      out.println(Tabbed(resort, toursRating, roomsRating))
    }
  }
}
