package ru.yandex.tours.tools

import java.io.{FileInputStream, FileOutputStream}

import org.apache.commons.io.IOUtils
import ru.yandex.tours.direction.CountryPriorities
import ru.yandex.tours.indexer.suggest.SuggestGenerator
import ru.yandex.tours.model.hotels.Features
import ru.yandex.tours.search.settings.SearchSettingsHolder

object SuggestGeoPreparer extends Tool {

  private def mapFile[T](fileName: String, skipLine: Boolean = true)(processor: String => T) = {
    (if (skipLine) {
      scala.io.Source.fromFile(fileName).getLines().toSeq.tail
    } else {
      scala.io.Source.fromFile(fileName).getLines().toSeq
    }).map(processor)
  }

  val additionalSynonyms = mapFile("util-heavy/python/geo/data/matchingresults/geo.synonyms.tsv")(line => {
    val parts = line.split("\t")
    parts(0).toInt -> parts(2)
  }).groupBy(_._1).map(t => t._1 -> t._2.map(_._2).toSet).withDefault(_ => Set.empty[String])

  val topFeatures = Features.topFeatures.toSet

  def hotels = ???

  val countryPriorities = CountryPriorities.parse(new FileInputStream("util-heavy/data/suggest/new_countries_priorities_for_suggest.tsv"))
  val resortPriorities = CountryPriorities.parse(new FileInputStream("util-heavy/data/suggest/new_resorts_priorities_for_suggest.tsv"))
  val hotelPriorities = CountryPriorities.parse(new FileInputStream("util-heavy/data/suggest/new_hotel_priorities_for_suggest.tsv"))

  val result = SuggestGenerator.generate(hotels,
                            geoMapping,
                            tree,
                            countryPriorities,
                            resortPriorities,
                            hotelPriorities,
                            new SearchSettingsHolder(Seq.empty, tree),
                            new FileInputStream("util-heavy/python/geo/data/matchingresults/geo.synonyms.tsv")
  )

  val os = new FileOutputStream("suggest_2")
  IOUtils.copy(new FileInputStream(result), os)
  result.delete()
  os.close()
}
