package ru.yandex.tours.tools

import java.io.PrintWriter

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.util.Try

object TolokaResultsConverter extends App {
  def urlMapping(fileName: String): Map[String, String] = {
    IO.readLines(fileName).map {
      case Tabbed(id, url) => url -> id
    }.toMap
  }


  val bookingUrls = urlMapping("booking_id_2_url.tsv")
  val ltUrls = urlMapping("lt_id_2_url.tsv")
  val ostrovokUrls = urlMapping("ostrovok_id_2_url.tsv")


  private def resolveUrl(url: String) = {
    if (url.startsWith("http://www.booking.com")) {
      (Partners.booking, bookingUrls(url))
    } else if (url.startsWith("https://ostrovok.ru")) {
      (Partners.ostrovok, ostrovokUrls(url))
    } else {
      (Partners.lt, ltUrls(url))
    }
  }

  val samePw = new PrintWriter("same.toloka.tsv")
  val differentPw = new PrintWriter("different.toloka.tsv")

  private val lines: Iterator[String] = scala.io.Source.fromFile("/Users/berkut/Downloads/toloka_results.tsv").getLines()
  lines.next
  lines.foreach { line => Try {
    val parts = line.split("\t")
    val (partner1, id1) = resolveUrl(parts(0))
    val (partner2, id2) = resolveUrl(parts(1))
    val same = parts(8) == "same"
    val pw = if (same) samePw else differentPw
    if (partner1 == Partners.lt) {
      pw.println(Seq(partner1.id, id1, partner2.id, id2).mkString("\t"))
    } else if (partner2 == Partners.lt) {
      pw.println(Seq(partner2.id, id2, partner1.id, id1).mkString("\t"))
    }
  }}

samePw.close ()
differentPw.close ()

}
