package ru.yandex.tours.tools

import java.io.File

import ru.yandex.tours.testkit.TestData


/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 14.04.15
 */
trait Tool extends App with TestData with TestDb with HotelAware {

  lazy val dataDir = new File("tours-data/data")

  lazy val tree = data.regionTree
  lazy val hotelsIndex = data.hotelsIndex
  lazy val geoMapping = data.geoMapping
  lazy val operators = data.tourOperators
  lazy val departures = data.departures
  lazy val directions = data.directions
  lazy val hotelRatings = data.hotelRatings
}
