package ru.yandex.tours.tools

import java.io.File

import ru.yandex.tours.app.{AkkaSupport, Application, CommonDataHolders, DefaultEnvironment}
import ru.yandex.tours.geo.matching.GeoMatchingHypotheses
import ru.yandex.tours.geo.partners.PartnerTreesSupport
import ru.yandex.tours.hotels.{FilteringHotelsIndex, HotelsIndex, ShardedYoctoHotelsIndex}
import shapeless.HNil

/**
  * Created by asoboll on 28.07.16.
  */
trait ToolDataHolders extends AnyRef with ToolExtDataSupport with CommonDataHolders with PartnerTreesSupport {
  app: Application with DefaultEnvironment with AkkaSupport =>

  implicit val ec = akkaSystem.dispatcher

  override val lazyLoadResources: Boolean = true

  lazy val geoMatchingHypotheses = GeoMatchingHypotheses.from(
    regionTree :: partnerTrees :: HNil,
    extDataService, extDataUpdateChecker, lazyLoadResources)

  override lazy val hotelsIndex: HotelsIndex = {
    val baseIndex = ShardedYoctoHotelsIndex.fromExtData(
      new File("tours-data/hotels_index"),
      hotelRatings, extDataService, extDataUpdateChecker, lazyLoadResources = false
    )
    new FilteringHotelsIndex(baseIndex, regionTree)
  }

}
