package ru.yandex.tours.tools

import java.io.File

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.provider.{HttpExtDataClient, RemoteExtDataService}
import ru.yandex.extdata.provider.cache.LocalFSDataCache
import ru.yandex.tours.app.{AkkaSupport, Application}
import ru.yandex.tours.extdata.{DataTypes, ExtDataSupport, ExtDataUpdateChecker}

/**
  * Created by asoboll on 28.07.16.
  */
trait ToolExtDataSupport extends ExtDataSupport { app: Application with AkkaSupport =>

  // ssh -L 36445:indexer01f.vs.yandex.net:36445 d2p.vs.yandex.net
  private lazy val extDataClient = new HttpExtDataClient("http://localhost:36445", 4, 10000)

  private lazy val localFSCache = {
    new File("tours-data/cache").mkdirs()
    val cache = new LocalFSDataCache(
      DataTypes.registry,
      extDataClient,
      "tours-data/cache",
      false
    )
    cache.afterPropertiesSet()
    cache
  }

  lazy val extDataService: ExtDataService = new RemoteExtDataService(localFSCache)

  lazy val extDataUpdateChecker: ExtDataUpdateChecker = ExtDataUpdateChecker.empty

}
