package ru.yandex.tours.tools

import java.io.File

import ru.yandex.tours.app.{AkkaSupport, Application, DefaultEnvironment}
import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

/**
  * Created by asoboll on 03.03.17.
  */
object TopRegions2Partner extends Application with DefaultEnvironment with AkkaSupport with ToolDataHolders {

  val partner = Partners.booking
  val fileName = "booking_regions.tsv"
  val sampleSize = 1000

  val partnerTree = partnerTrees(partner)


  def printTopMappings(data: Iterator[Region], file: File): Unit = {
    def header = "hc_id\tya_id\thc_name\tya_name\thc_country\tya_country"

    IO.printFile(file) { pw =>
      pw.println(header)
      data.foreach { region =>
        val partnerRegion = geoMappingHolder
          .getPartnerDestination(partner, region.id)
          .flatMap(partnerTree.region)

        pw.println(Tabbed(
          partnerRegion.fold("-")(_.id),
          region.id,
          partnerRegion.fold("-")(_.getName),
          region.getName,
          partnerRegion.flatMap(_.countryId).flatMap(partnerTree.region).fold("-")(_.getName),
          regionTree.country(region).fold("-")(_.getName)
        ))
      }
    }
  }


  printTopMappings(directionsStats.getPopularCities().iterator.take(sampleSize), new File(fileName))

}
