package ru.yandex.tours.tools

import java.io.{File, FileInputStream, FileOutputStream}

import ru.yandex.tours.indexer.agencies.{AgencyShowsParser, XmlAgencyParser}
import ru.yandex.tours.metro.MetroHolder

object XmlAgencyParserTool extends Tool {
  val parser = new XmlAgencyParser(tree, AgencyShowsParser.parse(new FileInputStream(new File("util-heavy/data/agencies/agencies.shows.stat.maps.filtered.tsv"))), Map.empty, new MetroHolder(Iterable.empty))
  val agencies = parser.parseFile("/Users/berkut/Downloads/companies2.xml")
  val os = new FileOutputStream("agencies.proto")
  agencies.foreach(_.writeDelimitedTo(os))
  os.close()
  println(agencies.size)
}
