package ru.yandex.tours.tools.ammo

import java.io.PrintWriter

import org.joda.time.LocalDate
import ru.yandex.tours.client.{RelativeSearchRequest, ShiftDate}
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.search.HotelSearchRequest
import ru.yandex.tours.partners.LtHttp
import ru.yandex.tours.tools.Tool

import scala.util.{Random, Try}

object LtAmmoTool extends Tool {
  private val FLEX_INTERVAL = 2

  private def createEnqueueUrl(request: HotelSearchRequest) = Try {
    val nightsInterval = if (request.flexNights) FLEX_INTERVAL else 0
    val region = tree.region(request.to).getOrElse(throw new Exception(s"Unknown LT to region: ${request.to}"))
    val country = tree.country(region).getOrElse(throw new Exception(s"Unknown LT to country: ${request.to}"))
    val fromCountry = tree.country(tree.region(request.from).get).getOrElse(throw new Exception(s"Unknown LT from country: ${request.from}")).id
    val from = geoMapping.getPartnerDeparture(Partners.lt, request.from).getOrElse(throw new Exception(s"Unknown LT from city: ${request.from}"))
    LtHttp.enqueue(
      from,
      geoMapping.getPartnerCountry(Partners.lt, fromCountry).get,
      geoMapping.getPartnerCountry(Partners.lt, country.id).get,
      request.nights - nightsInterval,
      request.nights + nightsInterval,
      request.adults,
      request.when,
      request.kidsAges,
      request.flexWhen,
      None,
      if (region != country) Some(geoMapping.getPartnerCity(Partners.lt, region.id).get) else None,
      LtHttp.starsRange(request.filter)
    )
  }

  val dests = (geoMapping.cityGeoIds ++ geoMapping.countryGeoIds).toSeq

  val pw = new PrintWriter("lt_ammo.txt")
  (0 to 200000).foreach(_ => {

    val to = dests(Random.nextInt(dests.size))
    val request = RelativeSearchRequest(
      213, to, Random.nextInt(10) + 4, ShiftDate(Random.nextInt(60) + 7), Seq(88, 88), true, true
    )
    val x = request.toHotelSearchRequest(LocalDate.now.plusDays(30))
    val url = createEnqueueUrl(x).get
    pw.println(url.replaceAll("https://api.level.travel/search/enqueue\\?", ""))
  })
  pw.close()

  private def parseFile(file: String) = {
    scala.io.Source.fromFile(file).getLines().map(RelativeSearchRequest.parse).flatMap(_.toOption)
  }
}
