package ru.yandex.tours.tools.ammo

import java.io.PrintWriter

import org.joda.time.LocalDate
import ru.yandex.tours.tools.Tool

object RoomsAmmoGenerator extends Tool {

  val tos = geoMapping.cityGeoIds.map { geoId =>
    tree.region(geoId).get.position -> geoId
  }.toArray.sortBy(-_._1).map(_._2)


  val pw = new PrintWriter("rooms_ammo.txt")
  for {
    to <- tos.take(100)
    nightsShift <- 0 until 7
    whenShift <- 0 until 60
  } {
    val when = new LocalDate("2015-10-01").plusDays(whenShift)
    val nights = 5 + nightsShift
    pw.println(s"/api/1.x/search/rooms?to=$to&nights=$nights&when=$when&request_index=1")
  }
  pw.close()
}
