package ru.yandex.tours.tools.analytics

import java.io.{PrintWriter, FileWriter}

import org.apache.hadoop.hbase.TableName
import org.apache.hadoop.hbase.client.{ConnectionFactory, HTable}
import org.apache.hadoop.hbase.util.Bytes
import org.joda.time.DateTime
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.tools.HBaseTool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed
import scala.collection.JavaConverters._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 22.05.15
 */
object ActualizationParser extends HBaseTool {

  val connection = ConnectionFactory.createConnection(bruny)
  val table = connection.getTable(TableName.valueOf("tours-tour_actualization-ru"))

  IO.using(
    getScanner(table, new DateTime(2015, 4, 1, 0, 0), DateTime.now()),
    new PrintWriter("actualizations.tsv")
  ) { (scanner, out) =>
    out.println(Tabbed(
      "timestamp",
      "tourId",
      "from", "to" ,"when",
      "hotelId",
      "operator",
      "price",
      "fuelCharge"
    ))
    for (row <- scanner.iterator.asScala) {
      val timestamp = row.str("timestamp")
      val tourId = row.str("tour_id")
      val from = row.str("from")
      val to = row.str("to")
      val when = row.str("when")
      val offer = row.compressedProto("result", ActualizedOffer.parseFrom)

      val price = offer.getOffer.getPrice
      val hotelId = offer.getOffer.getHotelId

      val operatorId = offer.getOffer.getSource.getOperatorId
      val operator = operators.getById(operatorId).fold(operatorId.toString)(_.name)

      val fuelCharge =
        if (offer.hasActualizationInfo) offer.getActualizationInfo.getFuelCharge.toString
        else ""

      out.println(Tabbed(
        timestamp,
        tourId,
        from, to ,when,
        hotelId,
        operator,
        price,
        fuelCharge
      ))
    }
  }
}
