package ru.yandex.tours.tools.analytics

import java.io.PrintWriter

import org.apache.hadoop.hbase.TableName
import org.apache.hadoop.hbase.client.{ConnectionFactory, HTable}
import org.joda.time.DateTime
import ru.yandex.tours.tools.HBaseTool
import ru.yandex.tours.tools.analytics.ActualizationParser._
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.JavaConverters._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 22.05.15
 */
object ClicksParser extends HBaseTool {
  val connection = ConnectionFactory.createConnection(bruny)
  val table = connection.getTable(TableName.valueOf("tours-click-ru-offers"))

  IO.using(
    getScanner(table, new DateTime(2015, 4, 1, 0, 0), DateTime.now()),
    new PrintWriter("clicks.tsv")
  ) { (scanner, out) =>
    out.println(Tabbed(
      "timestamp",
      "tourId",
      "url",
      "text",
      "pos",
      "isInYandex"
    ))
    for (row <- scanner.iterator.asScala) {
      val timestamp = row.str("timestamp")
      val isInYandex = row.str("user_is_in_yandex")
      val url = row.str("offer_url")
      val tourId = row.str("offer_id")
      val text = row.str("billing.header.name")
      val pos = row.str("offer_position")

      out.println(Tabbed(
        timestamp,
        tourId,
        url,
        text,
        pos,
        isInYandex
      ))
    }
  }
}
