package ru.yandex.tours.tools.analytics

import java.io.PrintWriter

import org.apache.hadoop.hbase.TableName
import org.apache.hadoop.hbase.client.{ConnectionFactory, HTable}
import org.joda.time.DateTime
import ru.yandex.tours.model.Languages
import ru.yandex.tours.tools.HBaseTool
import ru.yandex.tours.tools.analytics.ClicksParser._
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed
import scala.collection.JavaConverters._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.06.15
 */
object EmailsParser extends HBaseTool {
  val connection = ConnectionFactory.createConnection(bruny)
  val table = connection.getTable(TableName.valueOf("tours-ru-subscribe"))

  def name(rid: Int) = tree.region(rid).getOrElse(sys.error("")).name(Languages.ru)

  IO.using(
    getScanner(table, new DateTime(2015, 4, 1, 0, 0), DateTime.now()),
    new PrintWriter("emails.tsv")
  ) { (scanner, out) =>
    out.println(Tabbed(
      "timestamp",
      "email",
      "login",
      "from",
      "to",
      "from_name",
      "to_name"
    ))
    for (row <- scanner.iterator.asScala) {
      val timestamp = row.str("timestamp")
      val email = row.str("email")
      val from = row.int("from")
      val to = row.int("to")
      val login = row.str("login")

      out.println(Tabbed(
        timestamp,
        email,
        login,
        from,
        to,
        name(from),
        name(to)
      ))
    }
  }
}
