package ru.yandex.tours.tools.analytics

import ru.yandex.tours.model.filter.hotel.{GeoIdFilter, HotelTypeFilter}
import ru.yandex.tours.model.hotels.HotelsHolder.HotelType
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.11.15
 */
object HotelTypesTool extends Tool {

  private def pct(d: Double) = (d * 100).formatted("%.2f%%")

  IO.printFile("hotel_stats.csv") { pw =>
    pw.println(Tabbed(
      "region_id", "region_name",
      "total",
      "sanatorium", "sanatorium_ratio",
      "boarding_house", "boarding_house_ratio",
      "holiday_camp", "holiday_camp_ratio"
    ))

    for {
      geoId <- geoMapping.cityGeoIds
      region <- tree.region(geoId)
    } {
      val count = shardedHotelsIndex.count(GeoIdFilter(geoId))
      val sanatoriums = shardedHotelsIndex.count(GeoIdFilter(geoId), HotelTypeFilter(Set(HotelType.SANATORIUM)))
      val bhouses = shardedHotelsIndex.count(GeoIdFilter(geoId), HotelTypeFilter(Set(HotelType.BOARDING_HOUSE)))
      val hcamps = shardedHotelsIndex.count(GeoIdFilter(geoId), HotelTypeFilter(Set(HotelType.HOLIDAY_CAMP)))

      if (count > 0 && (sanatoriums > 0 || bhouses > 0 || hcamps > 0)) {
        pw.println(Tabbed(
          geoId,
          region.name.ruName,
          count,
          sanatoriums, pct(sanatoriums.toDouble / count) ,
          bhouses, pct(bhouses.toDouble / count),
          hcamps, pct(hcamps.toDouble / count)
        ))
      }
    }
  }

}
