package ru.yandex.tours.tools.analytics

import org.joda.time.LocalDate
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.stat.{HotelUpdateStatsExport, SpecstatClient}
import ru.yandex.tours.tools.{TestDb, Tool}
import ru.yandex.tours.util.http.NingHttpClient
import ru.yandex.tours.util.lang.Futures
import ru.yandex.tours.util.lang.Dates._

import scala.concurrent.Await
import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 05.03.16
 */
object HotelsStatsTool extends Tool with TestDb {
  import scala.concurrent.ExecutionContext.Implicits.global

  val dao = new HotelsDao(prodDb)
  val statClient = new SpecstatClient(new NingHttpClient(None), "stat.yandex-team.ru")(global)

  val tool = new HotelUpdateStatsExport(dao, statClient)

  val dates =
    Iterator.iterate(LocalDate.parse("2016-03-1"))(_.plusDays(1))
      .takeWhile(_ <= LocalDate.now())
      .toSeq

  val res = {
    Futures.lazyTraverse(dates)(tool.doExport)
  }
  Await.result(res, 1.hour)
  sys.exit(0)
}
