package ru.yandex.tours.tools.booking

import java.io.PrintWriter

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.tools.Tool

import scala.util.Try

/**
 * Booking feed doesn't have regions ids in its feed. So, we need do download last feed from their site: https://admin.booking.com/partner/hoteldump.html?affiliate_id=350687;partner_id=436575;ses=cdcc9a066f55fffa7dfa49c34b0bd70f
 * Then, run this tool to obtain mapping from booking_hotel_id to geo_id
 */

object BookingHotelRegionConverter extends Tool {
  val pw = new PrintWriter("booking_hotel2region.tsv")
  var unknown = 0
  var known = 0
  scala.io.Source.fromFile("/Users/berkut/Downloads/c5wdYmvwaScNwdcN8mWKjg.tsv").getLines().foreach { line => Try {
    val parts = line.split("\t")
    val hotelId = parts(0)
    val bookingRegionId = parts(6)
    geoMapping.getGeoId(Partners.booking, bookingRegionId) match {
      case Some(geoId) => known += 1; pw.println(s"$hotelId\t$geoId")
      case None => unknown += 1
    }
  }}
  pw.close()
  println(s"Finished. Unknown: $unknown, known: $known")
}
