package ru.yandex.tours.tools.db

import org.apache.commons.codec.binary.Hex
import ru.yandex.tours.hotels.amendings.SetGeoIdAmending
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

object AmendingsToSql extends Tool {
  val transactionId = 95
  val timestamp = System.currentTimeMillis()
  IO.printFile("geo_id_fallback.sql") { pw =>
    IO.readLines("geo_id_fallback.tsv").map { case Tabbed(IntValue(hotelId), IntValue(geoId)) =>
      SetGeoIdAmending(hotelId, timestamp, geoId)
    }.grouped(1000).foreach { batch =>
      val values = batch.map(ammending => {
        s"(${ammending.hotelId}, ${ammending.`type`.id}, '2016-02-15 22:23:00', x'${Hex.encodeHexString(ammending.serialize)}', $transactionId)"
      })
      val query = s"insert into hotel_amendments (hotel_id, type_id, timestamp, payload, transaction_id) values " + values.mkString(", ") + ";"
      pw.println(query)
    }
  }
}
