package ru.yandex.tours.tools.db

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.tools.HotelAware
import ru.yandex.tours.util.IO
import scala.collection.JavaConversions._

object ClusterToSqlScript extends App with HotelAware {
  val links = for {
    master <- hotels("sodis_final.proto")
    slave <- master.getChildrenList.toList
    if slave.getPartnerId != Partners.backa.id
  } yield master.getId -> slave.getId
  val queries = links.grouped(1000).map {
    batch =>
      val values = batch.map { case (master, slave) =>
        s"($master, $slave, 1, 0.7, 0)"
      }
    s"INSERT INTO clusterization (parent, child, transaction_id, confidence, link_type) VALUES ${values.mkString(",")};"
  }
  IO.printFile("clusters.sql") { pw =>
    queries.foreach(pw.println)
  }
}
