package ru.yandex.tours.tools.db

import java.io.File

import ru.yandex.tours.app.{Application, DefaultEnvironment}
import ru.yandex.tours.db.DefaultMySqlSupport
import ru.yandex.tours.db.tables.{Clusterization, ClusterLink}
import ru.yandex.tours.hotels.HotelIO
import slick.driver.MySQLDriver.api._

import scala.collection.JavaConversions._

object ClusterizationConverter extends Application with DefaultEnvironment with DefaultMySqlSupport {
  db.createIfNotExists(Clusterization.table)
  HotelIO.loadFromFileAsIterator(new File("sodis_final.proto")).flatMap { hotel =>
    val children = hotel.getChildrenList.filter(_.getPartnerId != 6)
    children.map { child =>
      ClusterLink(0, hotel.getId, child.getId, 1)
    }
  }.grouped(1000).foreach { slice =>
    db.run {
      Clusterization.table ++= slice
    }
  }
}
