package ru.yandex.tours.tools.db

import ru.yandex.tours.app.{Application, DefaultEnvironment}
import ru.yandex.tours.db._
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}
import scala.concurrent.duration._
import slick.driver.MySQLDriver.api._

import scala.concurrent.{Future, Await}
import scala.util.{Success, Failure}
import scala.concurrent.ExecutionContext.Implicits.global

object StableIdsUploader extends Application with DefaultEnvironment with DefaultMySqlSupport {
  Await.result(db.createIfNotExists(HotelStableIds.table), 1.minute)

  val ids = scala.io.Source.fromFile("data/stable_ids").getLines().map {
    case Tabbed(IntValue(partner), partnerId, IntValue(ourId)) =>
      HotelStableId(ourId, Partners(partner), partnerId)
  }.toList

  def load(ids: Iterator[HotelStableId]): Future[Unit] = {
    val batch = ids.take(10000).toList
    if (batch.isEmpty) {
      Future.successful {}
    } else {
      val q = HotelStableIds.table.forceInsertAll(batch)
      for {
        _ <- db.run(q)
        _ <- load(ids)
      } yield ()
    }
  }

  load(ids.toIterator).onComplete {
    case Failure(e) => println("Can not load stable ids: " + e.getMessage)
    case Success(e) => println("Success!")
  }
}
