package ru.yandex.tours.tools.db

import java.nio.file.StandardCopyOption._
import java.nio.file.{Files, Paths}

import akka.actor.ActorSystem
import ru.yandex.tours.backa.BackaPermalinks
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.db.tables.HotelAmendments
import ru.yandex.tours.geo.partners.{PartnerRegionHotelCounts, PartnerRegionsDef}
import ru.yandex.tours.hotels.enrichers.{CountryGeoIdBySpanSetter, GeoIdByPartnerRegionSetter, MetaGeoIdSetter}
import ru.yandex.tours.indexer.hotels.HotelsIndexer
import ru.yandex.tours.tools.hotels.hotelindexing.HotelIndexOnly.extDataService
import ru.yandex.tours.tools.{HotelAware, TestDb, Tool}
import shapeless.HNil

import scala.concurrent.Await
import scala.concurrent.duration._
import scala.util.{Failure, Success}

object TravelHotelRetrieveTool extends Tool with TestDb with HotelAware {
  implicit val as = ActorSystem.create()
  implicit val ec = as.dispatcher

  Await.result(testDb.createIfNotExists(HotelAmendments.table), 1.minute)

  val hotelsDao = new HotelsDao(testDb)

  val partnerTree = PartnerRegionsDef.from(PartnerRegionHotelCounts.empty :: HNil, extDataService)
  val backaPermalinks = BackaPermalinks.from(extDataService)
  val partnerRegionSetter = new GeoIdByPartnerRegionSetter(data.geoMapping, partnerTree, data.regionTree)
  val countrySetter = CountryGeoIdBySpanSetter.from(data.regionTree :: HNil)
  val meta = new MetaGeoIdSetter(partnerRegionSetter, countrySetter)
  val indexer = new HotelsIndexer(testDb, hotelsDao, meta, data.regionTree, hotelRatings, backaPermalinks, null, 12.hours)
  val result = indexer.retrieveTravelHotels()
  result.onComplete {
    case Success(file) =>
      Files.move(Paths.get(file.getAbsolutePath), Paths.get("new_travel.proto"), REPLACE_EXISTING)
      println("Done!")
    case Failure(e) => e.printStackTrace()
  }
  println("End!")
}
