package ru.yandex.tours.tools.geo

import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.model.filter.hotel.GeoIdFilter
import ru.yandex.tours.model.util.Paging
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.parsing.Tabbed

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.03.16
 */
object InvalidSpanTool extends Tool {
  val stats = data.directionsStats

  def print(regions: Seq[Region]): Unit = {
    val sorted = regions.sortBy(r => stats.getPriority(r.id))
    sorted.foreach { r =>
      val countryName = tree.country(r).fold("")(_.name.ruName)
      println(Tabbed(
        r.id,
        r.name.ruName,
        countryName,
        r.boundingBox,
        stats.getPriority(r.id)
      ))
    }
    println(sorted.length)
  }

  def printEmpty(): Unit = {
    val empty = tree.regions.filter(_.boundingBox.isEmpty).toArray
      .filter(r => data.geoMapping.isKnownDestination(r.id))

    print(empty)
  }

  def printMalformed(): Unit = {
    val malformed = tree.regions.toArray
      .filter(r => data.geoMapping.isKnownDestination(r.id))
      .filter(_.boundingBox.nonEmpty).par
      .filter(r => {
        val hotels = shardedHotelsIndex.getHotels(
          Paging(0, 10000),
          GeoIdFilter(r.id)
        )
        val (inside, outside) = hotels.partition(r.boundingBox.extend(0.1).contains)
        inside.isEmpty && outside.nonEmpty
      })

    print(malformed.seq)
  }

//  printEmpty()
  printMalformed()
}
