package ru.yandex.tours.tools.graphite

import java.io.{PrintWriter, StringWriter}

import ru.yandex.tours.tools.Tool

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 08.12.15
 */
object DashboardGenerator extends Tool {
  val sw = new StringWriter()
  val writer = new PrintWriter(sw)

  writer.println("[")

  val macros = "%vs_back-auto-stable"
//  val macros = "%cs_back-testing"
  var first = true

  def genHttpHandler(name: String, title: String) = {
    if (!first) writer.print(",")
    else first = false
    writer.print(
      s"""  {
        |    "areaMode": "stacked",
        |    "lineWidth": "2",
        |    "areaAlpha": "0.6",
        |    "target": [
        |      "alias(sum(*.$macros@iva.tours-api.http.$name.status.2xx.m1_rate),'iva')",
        |      "alias(sum(*.$macros@fol.tours-api.http.$name.status.2xx.m1_rate),'fol')",
        |      "alias(sum(*.$macros@myt.tours-api.http.$name.status.2xx.m1_rate),'myt')",
        |      "alias(sum(*.$macros@sas.tours-api.http.$name.status.2xx.m1_rate),'sas')"
        |    ],
        |    "title": "$title 2xx"
        |  },
        |  {
        |    "target": [
        |      "alias(maxSeries(*.$macros.tours-api.http.$name.timing.p50),'50%')",
        |      "alias(maxSeries(*.$macros.tours-api.http.$name.timing.p75),'75%')",
        |      "alias(maxSeries(*.$macros.tours-api.http.$name.timing.p95),'95%')",
        |      "alias(maxSeries(*.$macros.tours-api.http.$name.timing.p99),'99%')",
        |      "alias(maxSeries(*.$macros.tours-api.http.$name.timing.p999),'99.9%')",
        |      "alias(maxSeries(*.$macros.tours-api.http.$name.timing.max),'100%')"
        |    ],
        |    "title": "$title timings",
        |    "areaMode": "all",
        |    "areaAlpha": "0.6",
        |    "lineWidth": "2",
        |    "colorList": "red,#008000,#00b300,#00e600,#bef574,#ebfcd4",
        |    "yMax": "2000.0"
        |  },
        |  {
        |    "target": [
        |      "alias(sum(*.$macros.tours-api.http.$name.status.3xx.m1_rate), '3xx')",
        |      "alias(sum(*.$macros.tours-api.http.$name.status.4xx.m1_rate), '4xx')",
        |      "alias(sum(*.$macros.tours-api.http.$name.status.5xx.m1_rate), '5xx')",
        |      "alias(sum(*.$macros.tours-api.http.$name.timeout.m1_rate),'timeout')"
        |    ],
        |    "title": "$title errors",
        |    "areaMode": "all",
        |    "areaAlpha": "0.6",
        |    "lineWidth": "2",
        |    "yMax": "2.0"
        |  },
        |  {
        |    "target": [
        |      "alias(sum(*.$macros@iva.tours-api.http.$name.status.5xx.m1_rate),'iva')",
        |      "alias(sum(*.$macros@fol.tours-api.http.$name.status.5xx.m1_rate),'fol')",
        |      "alias(sum(*.$macros@myt.tours-api.http.$name.status.5xx.m1_rate),'myt')",
        |      "alias(sum(*.$macros@sas.tours-api.http.$name.status.5xx.m1_rate),'sas')"
        |    ],
        |    "title": "$title 5xx by dc",
        |    "areaMode": "all",
        |    "areaAlpha": "0.6",
        |    "lineWidth": "2"
        |  }""".stripMargin)
  }

  genHttpHandler("hotel.root", "hotel/*")
  genHttpHandler("hotel.info", "hotel/info")
  genHttpHandler("hotel.near_hotels_with_rect", "hotel/near with bounds")
  genHttpHandler("hotel.near_hotels", "hotel/near without bounds")
  genHttpHandler("hotel.near_cities", "hotel/near_cities")
  genHttpHandler("hotel.near_countries", "hotel/near_countries")
  genHttpHandler("hotel.tours_search", "hotel/tours/search")
  genHttpHandler("hotel.tours_tour_info", "hotel/tours/<tour-id>")
  genHttpHandler("hotel.tours_tour_actualization", "hotel/tours/<tour-id>/actualization")
  genHttpHandler("hotel.tours_similar", "hotel/tours/similar")
  genHttpHandler("hotel.rooms_search", "hotel/rooms/search")
  genHttpHandler("hotel.rooms_similar", "hotel/rooms/similar")

  genHttpHandler("recommend.another_cities", "recommend/another_cities")
  genHttpHandler("recommend.another_countries", "recommend/another_countries")
  genHttpHandler("recommend.another_directions", "recommend/another_directions")
  genHttpHandler("recommend.search_request", "recommend/search_request")
  genHttpHandler("recommend.tours_recommend", "recommend/tours")
  genHttpHandler("recommend.tours_recommend_thematic", "recommend/tours/directions?<thematic>")
  genHttpHandler("recommend.tours_recommend_directions", "recommend/tours/directions")
  genHttpHandler("recommend.rooms_recommend", "recommend/rooms")
  genHttpHandler("recommend.rooms_recommend_thematic", "recommend/rooms/directions?<thematic>")
  genHttpHandler("recommend.rooms_recommend_directions", "recommend/rooms/directions")

  genHttpHandler("search.tours_map_info", "search/tours/map_info")
  genHttpHandler("search.tours_search", "search/tours")
  genHttpHandler("search.tours_another", "search/tours/another")
  genHttpHandler("search.tours_top", "search/tours/top")
  genHttpHandler("search.rooms_map_info", "search/rooms/map_info")
  genHttpHandler("search.rooms_search", "search/rooms")
  genHttpHandler("search.rooms_another", "search/rooms/another")
  genHttpHandler("search.rooms_top", "search/rooms/top")

  genHttpHandler("search.flights", "search/flights")
  genHttpHandler("search.transfers", "search/transfers")

  genHttpHandler("statistics.calendar", "statistics/calendar")
  genHttpHandler("statistics.tour_operators_state", "statistics/tour_operators_state")
  genHttpHandler("statistics.tours_min_prices", "statistics/tours/min_prices")
  genHttpHandler("statistics.tours_avia", "statistics/tours/avia")
  genHttpHandler("statistics.rooms_min_prices", "statistics/rooms/min_prices")
  genHttpHandler("statistics.rooms_avia", "statistics/rooms/avia")

  genHttpHandler("subscriptions.query", "subscriptions/query")

  genHttpHandler("resorts.ski", "resorts/ski")

  genHttpHandler("reference.departures", "reference/departures")
  genHttpHandler("reference.operators", "reference/operators")
  genHttpHandler("reference.hotel_providers", "reference/hotel_providers")
  genHttpHandler("reference.destinations", "reference/destinations")
  genHttpHandler("reference.metros", "reference/metros")
  genHttpHandler("reference.flight_matrix", "reference/flight_matrix")
  genHttpHandler("reference.agency_cities", "reference/agency_cities")
  genHttpHandler("reference.partners", "reference/partners")
  genHttpHandler("reference.country_info", "reference/country_info")
  genHttpHandler("reference.hotels", "reference/hotels")
  genHttpHandler("reference.geobase", "reference/geobase")
  genHttpHandler("reference.ota_regions", "reference/ota/regions")
  genHttpHandler("reference.ota_operators", "reference/ota/operators")
  genHttpHandler("reference.ota_hotels", "reference/ota/hotels")



  writer.println()
  writer.println("]")

  writer.close()
  println(sw.toString)
}
