package ru.yandex.tours.tools.hotels

import java.io.PrintWriter

import ru.yandex.tours.db.tables.Clusterization.LinkWithInfo
import ru.yandex.tours.db.tables.{Clusterization, Hotels, LinkType}
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.collections.Graph
import ru.yandex.tours.util.parsing.Tabbed
import slick.driver.MySQLDriver.api._

import scala.collection.mutable
import scala.concurrent.Await
import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.04.16
 */
object BigClusterRetriever extends Tool {


  val db = prodDb


  val links = Await.result(Clusterization.retrieveClusterLinks(0, db, "Tool"), 1.hour)

  val set = mutable.Set.empty[(Int, Int)]
  val manual = mutable.Set.empty[(Int, Int)]
  links.sortBy(l => (l.isManual, l.timestamp)).foreach {
    case LinkWithInfo(from, to, _, linkType, _, author) =>
      linkType match {
        case LinkType.MERGE =>
          set += from -> to
          if (author > 0) manual += (from → to)
        case LinkType.UNMERGE =>
          set -= from -> to
          if (author > 0) manual -= (from → to)

      }
  }
  val graph = new Graph(set)

  private val sorted = graph.getConnectedComponents.sortBy(-_.size)
  sorted.take(200)
    .foreach { c =>
      println(s"${c.head} with size = ${c.size} \t https://travel-admin.vertis.yandex-team.ru/hotels/cluster/${c.head}")
    }

}
