package ru.yandex.tours.tools.hotels

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel

import scala.collection.JavaConversions._

object CoordinatesByExternalFileTool extends App {
  val hotels = HotelIO.loadFromFileAsIterator("rosa_hutor.proto")

  def setCoord(builder: Hotel.Builder, lat: Double, lon: Double) = {
    val point = Point.newBuilder().setLatitude(lat).setLongitude(lon).build
    builder.setPoint(point)
  }

  def setChildCoord(builder: Hotel.Builder, childId: Int) = {
    builder.setPoint(builder.getChildrenList.find(_.getId == childId).get.getPoint)
  }

  def updateCoord(builder: Hotel.Builder): Unit = {
    builder.getId match {
      case 1017335 => setCoord(builder, 43.671411, 40.305578)
      case 1908852 => setCoord(builder, 43.660965, 40.317689)
      case 1908767 => setCoord(builder, 43.672787, 40.297406)
      case 1000398 => setCoord(builder, 43.672312, 40.294981)
      case 1000403 => setChildCoord(builder, 1908815)
      case 1017338 => setCoord(builder, 43.687079, 40.281251)
      case 1000399 => setCoord(builder, 43.690629, 40.274987)
      case 1018688 => setChildCoord(builder, 1908788)
      case 1000390 => setCoord(builder, 43.668588, 40.261748)
      case 1000412 => setChildCoord(builder, 1908904)
      case 1000411 => setCoord(builder, 43.669095, 40.260279)
      case 1000406 => setCoord(builder, 43.683846, 40.256821)
      case 1000144 => setChildCoord(builder, 2260165)
      case 1013769 => setCoord(builder, 43.680794, 40.230326)
      case 1908869 => setCoord(builder, 43.684986, 40.219393)
      case _ =>
    }
  }

  HotelIO.dumpToFile(HotelIO.loadFromFileAsIterator("rosa_hutor.proto").map { hotel =>
    val builder = hotel.toBuilder
    updateCoord(builder)
    builder.build()
  }, "coords_updated.proto")
}
