package ru.yandex.tours.tools.hotels

import java.io.PrintWriter

import ru.yandex.tours.filter.{Filters, HotelFilterHolder}
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.hotels.HotelsHolder.TravelHotel
import ru.yandex.tours.tools.Tool

import scala.collection.mutable

object FilterFitTool extends Tool {
  val hotels: TraversableOnce[TravelHotel] = ???

  class FilterStatistic(val holder: HotelFilterHolder, val geoId: Int, var matched: Int = 0, var total: Int = 0)

  val geoId2statistic = mutable.HashMap.empty[Int, mutable.HashMap[HotelFilterHolder, FilterStatistic]]

  for {
    hotel <- hotels
    modelHotel = Hotel(hotel)
    filterHolder <- Filters.hotelHolders
    hotelFeatures = filterHolder.getValues(modelHotel)
    region <- tree.pathToRoot(hotel.getGeoId)
    statisticMap = geoId2statistic.getOrElseUpdate(region.id, mutable.HashMap.empty[HotelFilterHolder, FilterStatistic])
    statistic = statisticMap.getOrElseUpdate(filterHolder, new FilterStatistic(filterHolder, region.id))
  } {
    statistic.total += 1
    if (filterHolder.construct(filterHolder.getValues).fits(hotelFeatures)) {
      statistic.matched += 1
    }
  }

  val pw = new PrintWriter("hidden_filter.tsv")
  geoId2statistic.flatMap(_._2.values).foreach { statistic =>
    if (statistic.matched * 20 < statistic.total) {
      val region = tree.region(statistic.geoId).get
      pw.println(Seq(region.id, statistic.holder.name).mkString("\t"))
    }
  }
  pw.close()
}
