package ru.yandex.tours.tools.hotels

import java.io.PrintWriter
import java.util.concurrent.ArrayBlockingQueue
import java.util.concurrent.atomic.LongAdder

import akka.util.Timeout
import org.joda.time.LocalDate
import play.api.libs.json.{JsArray, Json}
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.search.HotelSearchRequest
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.http.NingHttpClient
import ru.yandex.tours.util.parsing.Tabbed

import scala.concurrent.Await
import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.duration._
import scala.util.control.NonFatal

object GeoIdByPartnerTool extends Tool {
  val httpClient = new NingHttpClient(None)

  case class Request(regionId: String, request: HotelSearchRequest)
  val queue = new ArrayBlockingQueue[Request](1000)
  // TODO: insert token here before running. Do not check-in token to source control!
  val token = ""
  val results = new PrintWriter("ostrovok_hotel_geo_ids.tsv")
  val partner = Partners.ostrovok
  val downloaded = new LongAdder()
  val failed = new LongAdder()
  implicit val timeout = Timeout(60.seconds)

  val requests = for {
    to <- geoMapping.cityGeoIds
    partnerRegionId <- geoMapping.getPartnerCity(partner, to).toIterable
    shift <- 0 until 4
    when = LocalDate.now().plusDays(5).plusMonths(shift)
  } yield Request(partnerRegionId, HotelSearchRequest(0, to, 3, when, Seq(88, 88)))

  println(s"Total requests to execute: ${requests.size}")

  def getUri(request: Request) = {
    val Request(region, searchRequest) = request
    val geoId = searchRequest.to
    val checkIn = searchRequest.when
    val checkOut = searchRequest.when.plusDays(searchRequest.nights)
//    Ostrovok
    //OstrovokHttp.hotelRates(region.toInt, 2, checkIn, checkOut, Iterable.empty[Int], None)

//    Booking
//    if (region.startsWith("r")) {
//      BookingHttp.hotelAvailabilityByRegion(region.substring(1), searchRequest.guestsWithoutInfants, checkIn, checkOut)
//    } else {
//      BookingHttp.hotelAvailabilityByCity(region, searchRequest.guestsWithoutInfants, checkIn, checkOut)
//    }
  }

  def getHotelIds(result: String) = {
//    Ostrovok
    val json = Json.parse(result)
    (json \ "result" \ "hotels").as[JsArray].value.map(_ \ "id").map(_.as[String])
//    Booking
//    json.as[JsArray].value.map(_ \ "hotel_id").map(_.as[String])
  }

  /*
  def execute(request: Request) = {
    val uri = getUri(request)
    try {
      val response = Await.result(
        httpClient.get(uri, List(("Authorization", token))),
        60.seconds
      )
      downloaded.increment()
      if (response._1.intValue != 200) throw new Exception("Not 200 sc")
      val hotelIds = getHotelIds(response._2)
      hotelIds.foreach { hotelId =>
        results.println(Tabbed(hotelId, request.request.to))
      }
      results.flush()
    } catch {
      case NonFatal(e) =>
        println(s"Failed to download ${uri.toString()}: ${e.getMessage}")
        failed.increment()
    }
  }
  */

  new Thread("pusher") {
    override def run(): Unit = {
      requests.foreach(queue.put)
    }
  }.start()

  def starWorker(i: Int): Unit = {
    new Thread("worker-" + i) {
      override def run(): Unit = {
        while(true) {
          val i = queue.take()
          //execute(i)
        }
      }
    }.start()
  }

  (0 until 5).foreach(starWorker)

  val started = System.currentTimeMillis()
  new Thread("stats-logger") {
    override def run(): Unit = {
      while (true) {
        Thread.sleep(5000)
        val now = System.currentTimeMillis()
        val elapsed = (now - started).millis.toMinutes
        println(s"Downloaded ${downloaded.intValue()} images out of ${requests.size} in $elapsed minutes. Failed: ${failed.intValue}")
      }
    }
  }.start()
}
