package ru.yandex.tours.tools.hotels

import java.io.{File, FileOutputStream}

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.tools.Tool

import scala.collection.JavaConversions._

object GeoIdFix extends Tool {
  private val hotels = HotelIO.loadFromFileAsIterator(new File("photo_corrected.proto"))

  val os = new FileOutputStream("fixed_geo_id.proto")
  var fixedCount = 0
  val fixed = hotels.map { hotel =>
    val pathes = (hotel :: hotel.getChildrenList.toList).map(_.getGeoId).map(geoId => tree.pathToRoot(geoId))
    val longest = pathes.maxBy(_.size)
    val head = tree.pathToRoot(hotel.getGeoId)
    val conflict = pathes.exists(path => (longest.toSet & path.toSet).size != path.size)
    if (!conflict && head.size != longest.size) {
      fixedCount += 1
      hotel.toBuilder.setGeoId(longest.head.id).build
    } else {
      hotel
    }
  }
  fixed.foreach(_.writeDelimitedTo(os))
  println("Fixed : " + fixedCount)
  os.close()
}
