package ru.yandex.tours.tools.hotels

import ru.yandex.tours.geo
import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.geo.base.region.Types
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.Languages
import ru.yandex.tours.model.hotels.HotelsHolder.TravelHotel
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

object GeoIdFixByBoundingBox extends Tool {
  val hotels: TraversableOnce[TravelHotel] = ???
  IO.printFile("hotel_geo_id_by_span.tsv") { pw =>
    hotels.filter(HotelsIndex.isIndexable).foreach { hotel =>
      val country = tree.country(hotel.getGeoId).get
      val candidates = tree.allChildren(country).filter { region =>
        region.boundingBox.nonEmpty && region.boundingBox.contains(hotel.getPoint.getLongitude, hotel.getPoint.getLatitude) && !isStrange(region)
      }
      if (candidates.nonEmpty && tree.region(hotel.getGeoId).get.`type`.id < 6) {
        val best = candidates.toSeq.sortBy { region =>
          region.boundingBox.latSpan * region.boundingBox.lonSpan
        }.head
        val bestRegionPath = regionPath(best)
        val currentRegionPath = regionPath(tree.region(hotel.getGeoId).get)
        if (hotel.getGeoId != best.id) {
          pw.println(Tabbed(hotel.getId, s"https://travel.yandex.ru/hotel/${hotel.getId}#hotel__map", bestRegionPath, best.id, currentRegionPath, hotel.getGeoId, s"https://www.google.ru/maps/place/${hotel.getPoint.getLatitude}+${hotel.getPoint.getLongitude}"))
        }
        true
      } else {
        false
      }
    }
  }

  private def regionPath(region: Region) = {
    tree.pathToRoot(region).map(_.name(Languages.ru)).mkString(", ")
  }

  private def isStrange(region: Region) = {
    val bb = region.boundingBox
    val length = geo.distanceInKm(bb.minLat, bb.minLon, bb.maxLat, bb.minLon)
    val width = geo.distanceInKm(bb.minLat, bb.minLon, bb.minLat, bb.maxLon)
    region.`type`.id > 6 && region.`type` != Types.OverseasLand && region.`type` != Types.FederalSubjectRegion &&
    length * width >= 30000
  }

  private def boolToInt(x: Boolean) = if (x) 1 else 0
}
