package ru.yandex.tours.tools.hotels

import java.io.{File, FileOutputStream}

import ru.yandex.tours.hotels.{HotelIO, HotelsUtil}
import ru.yandex.tours.model.hotels.HotelsHolder.TravelHotel
import ru.yandex.tours.model.hotels.{HotelsHolder, Partners}
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.Collections._
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

import scala.io.Source

object GeoIdFixByExternalFile extends Tool {

  val fixedGeoIds = Source.fromFile("data/hotel_geo_id_by_neighbour.tsv").getLines().map {
    case Tabbed(IntValue(hotelId), googleUrl, _, IntValue(newId), _, _, IntValue(oldId), _) =>
      hotelId -> newId
  }.toMap ++ Map(
    1877967 -> 98631,
    1877964 -> 98631,
    1877862 -> 98631,
    1877912 -> 98631
  )

  // Use 'shardedHotels' instead 'hotels("path")' if needed
  val rawHotels: TraversableOnce[TravelHotel] = ???

  def patchedHotels = HotelsUtil.updateTravelHotels(rawHotels, hotel => {
    fixedGeoIds.get(hotel.getId).foreach {
      geoId => hotel.setGeoId(geoId)
    }
  })

  HotelsSharder.writeSharded(patchedHotels, new File("."))

  sys.exit()


  private val partner = Partners.booking
  private val externalGeoIds = scala.io.Source.fromFile(new File("booking_uniq_hotel_geo_id.tsv")).getLines().map {
    case Tabbed(hotelId, IntValue(geoId)) => hotelId -> geoId
  }.toIterable.toMultiMap
  private val hotels = HotelIO.loadFromFileAsIterator(new File("fixed_geo_id.proto"))

  var fixedCount = 0
  var conflicts = 0

  def update(builder: HotelsHolder.Hotel.Builder): Unit = {
    if (builder.getPartnerId == partner.id && externalGeoIds.contains(builder.getLocalId)) {
      val candidates = builder.getGeoId :: externalGeoIds(builder.getLocalId)
      val pathes = candidates.map(tree.pathToRoot)
      val longest = pathes.maxBy(_.size)
      val head = tree.pathToRoot(builder.getGeoId)
      val conflict = pathes.exists(path => (longest.toSet & path.toSet).size != path.size)
      if (conflict) {
        conflicts += 1
      } else if (head.size != longest.size) {
        fixedCount += 1
        builder.setGeoId(longest.head.id).build
      }
    }
  }

  val os = new FileOutputStream("fixed_booking_geo_id.proto")
  HotelsUtil.updateHotels(hotels, update).foreach(_.writeDelimitedTo(os))
  println(s"Updated: $fixedCount")
  println(s"Conflicts: $conflicts")
  os.close()
}
