package ru.yandex.tours.tools.hotels

import java.nio.file.StandardCopyOption._
import java.nio.file.{Files, Paths}

import ru.yandex.tours.indexer.hotels.HiddenFiltersCalculator
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.hotels.HotelsHolder.TravelHotel
import ru.yandex.tours.tools.Tool

object HiddenFiltersTool extends Tool {
  val hotels: TraversableOnce[TravelHotel] = ???
  val indexer = new HiddenFiltersCalculator(tree)
  val result = indexer.process(hotels.map(Hotel.apply))
  Files.move(Paths.get(result.getAbsolutePath), Paths.get("hidden_filter.tsv"), REPLACE_EXISTING)
}
