package ru.yandex.tours.tools.hotels

import ru.yandex.tours.db.tables.HotelAmendments
import HotelAmendments.DbHotelAmending
import ru.yandex.tours.db.Transactions
import ru.yandex.tours.hotels.amendings.SetGeoIdAmending
import ru.yandex.tours.tools.{TestDb, Tool}
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.lang.Futures
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}
import slick.driver.MySQLDriver.api._

import scala.concurrent.Await
import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.02.16
 */
object HotelAmendingUpdater extends Tool with TestDb {

  import scala.concurrent.ExecutionContext.Implicits.global

  private val db = testDb
  val res = Transactions.withTransaction(db) { transaction =>

    val amendments = IO.readLines("hotel_geo_id_by_neighbour.tsv").map {
      case Tabbed(IntValue(hotelId), IntValue(geoId), _*) =>
        SetGeoIdAmending(hotelId, transaction.timestamp, geoId)
    }.toSeq

    println(s"loaded ${amendments.size} amendments")

    val dbAmendments = amendments.map(am => DbHotelAmending(-1, transaction.id, am))

    Futures.lazyTraverse(dbAmendments.grouped(500).toSeq) {
      group =>
        val q = HotelAmendments.table ++= group
        db.run(q)
    }
  }

  Await.result(res, 10.hours)
}
