package ru.yandex.tours.tools.hotels

import java.io.PrintWriter

import ru.yandex.tours.tools.Tool

object HotelAndRegionExportTool extends Tool {
  var pw = new PrintWriter("countries.tsv")
  geoMapping.countryGeoIds.foreach(geoId => {
    val region = tree.region(geoId).get
    pw.println((Seq(region.id) ++ region.allNames).mkString("\t"))
  })
  pw.close()
  pw = new PrintWriter("cities.tsv")
  geoMapping.cityGeoIds.foreach(geoId => {
    val region = tree.region(geoId).get
    pw.println((Seq(region.id) ++ region.allNames).mkString("\t"))
  })
  pw.close()
  pw = new PrintWriter("hotels.tsv")
  pw.println(Seq("id", "geo_id", "lat", "lon", "name", "rating", "stars").mkString("\t"))
  hotelsIndex.hotels.foreach(hotel => {
    val x = Seq(
      hotel.id,
      hotel.geoId,
      hotel.latitude,
      hotel.longitude,
      hotel.name.allValues.mkString(" # "),
      hotel.rating,
      hotel.star.id
    ).mkString("\t")
    pw.println(x)
  })
  pw.close()
}
