package ru.yandex.tours.tools.hotels

import ru.yandex.tours.db.GridPoint
import ru.yandex.tours.db.tables.HotelCoordinates
import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.concurrent.BatchExecutor
import slick.driver.MySQLDriver.api._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.duration._
import scala.concurrent.{Await, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.03.16
 */
object HotelDbIndexTool extends Tool {
  private val db = prodDb

  /*val dao = new HotelsDao(db)(global)

  val map = Await.result(dao.retrieveRafMap(), 1.hour)
  println(map)

  val res = BatchExecutor.executeInBatch[PartnerHotel](
    objects = map.valuesIterator,
    name = "hotels index updated in database",
    batchSize = 1000,
    action = dao._updateIndex
  )
  Await.result(res, 5.hours)
  map.close()*/

  val points = Await.result(db.run(HotelCoordinates.table.map(t ⇒ t.id → t.point).result), 1.hour)

  println(s"Loaded ${points.size} points")

  def update(data: Iterable[(Int, Point)]): Future[_] = {
    val ids = data.map(_._1).toSet
    val delete = {
      HotelCoordinates.table.filter(_.id.inSet(ids)).delete
    }
    val insert = HotelCoordinates.table ++= data.map { case (id, point) ⇒ Tuple3(id, point, GridPoint.fromPoint(point))}
    db.run(DBIO.seq(delete, insert).transactionally)
  }

  val res2 = BatchExecutor.executeInBatch[(Int, Point)](
    objects = points.iterator,
    name = "grid index updated in database",
    batchSize = 1000,
    action = update
  )
  Await.result(res2, 5.hours)
}
