package ru.yandex.tours.tools.hotels

import java.io.File

import ru.yandex.tours.hotels.{HotelIO, HotelsUtil}
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.parsers.common.FileStableIds
import ru.yandex.tours.tools.Tool

import scala.concurrent.Await
import scala.concurrent.duration._

object HotelIdSetter extends Tool {
  // Input: proto hotels, ids file, output file
  // Output: proto hotels, where hotels has its own ids

  val protoFilePrefix = "lt.hotels"
  val stableIds = new FileStableIds("data/stable_ids")
  val hotels = HotelIO.loadFromFileAsIterator(new File(s"$protoFilePrefix.proto"))

  def update(hotel: Hotel.Builder) {
    val id = Await.result(stableIds.getId(Partners(hotel.getPartnerId), hotel.getLocalId), 1.minute)
    hotel.setId(id)
  }

  val updatedHotels = HotelsUtil.updateHotels(hotels, update)

  HotelIO.dumpToFile(updatedHotels, s"$protoFilePrefix.ided.proto")
  stableIds.persist()
}
