package ru.yandex.tours.tools.hotels

import java.io.{FileOutputStream, File}

import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.HotelsHolder.HotelType

object HotelTypeSetter extends App {
  private val lines: Iterator[String] = scala.io.Source.fromFile("/Users/berkut/Downloads/hotel.mainclusterid.types.tsv").getLines()
  lines.next()
  val hotel2type = lines.map { line =>
    val parts = line.split("\t")
    parts(0).toInt -> HotelType.valueOf(parts(1).toUpperCase)
  }.toMap


  val os = new FileOutputStream("hotel_with_types.proto")
  var set = 0
  HotelIO.loadFromFileAsIterator(new File("hotel_with_slopes.proto")).map { hotel =>
    hotel2type.get(hotel.getId) match {
      case Some(t) if t != HotelType.UNKNOWN =>
          set += 1
          hotel.toBuilder.setType(t).build()
      case _ => hotel
    }
  }.foreach(_.writeDelimitedTo(os))
  os.close()
  println(set)
}
