package ru.yandex.tours.tools.hotels

import java.io.{File, FileOutputStream}
import java.util.zip.GZIPOutputStream

import ru.yandex.tours.hotels.{HotelsUtil, ShardedYoctoHotelsIndex, YoctoHotelsIndex}
import ru.yandex.tours.model.hotels.HotelsHolder.TravelHotel
import ru.yandex.tours.tools.Tool
import ru.yandex.tours.util.file._

object HotelsSharder extends Tool {
  def sharder(i: Int): Int = i % ShardedYoctoHotelsIndex.SHARDS_COUNT

  def fixGeoId(hotels: TraversableOnce[TravelHotel]): TraversableOnce[TravelHotel] = {
    HotelsUtil.updateTravelHotels(hotels, hotel => {
      hotel.getGeoId match {
        case 116355 => hotel.setGeoId(114419)
        case 111003 => hotel.setGeoId(21455)
        case _ =>
      }
    })
  }

  def cleanHotels(hotels: TraversableOnce[TravelHotel]) = hotels.filter { hotel =>
    hotel.getId != 2159183 && hotel.getId != 1876301
  }

  def prepareHotels(hotels: TraversableOnce[TravelHotel]) = {
    fixGeoId(cleanHotels(hotels))
  }

  def writeSharded(hotels: => TraversableOnce[TravelHotel], dir: File): Unit = {
    for (shard <- 0 to 9) {
      val shardHotels = prepareHotels(hotels).filter { hotel =>
        tree.region(hotel.getGeoId).getOrElse(sys.error(s"Hotel geo_id is unknown: ${hotel.getGeoId}"))
        val country = tree.country(hotel.getGeoId).get
        val currentShard = sharder(country.id) % ShardedYoctoHotelsIndex.SHARDS_COUNT
        currentShard == shard
      }

      val os = new GZIPOutputStream(new FileOutputStream(dir / s"shard.$shard.yocto.gz"))
      YoctoHotelsIndex.build(shardHotels, tree, hotelRatings, os)
      os.close()
    }
  }

//  writeSharded(hotelsForExport, new File("."))
}
