package ru.yandex.tours.tools.hotels

import java.io.{File, FileOutputStream}

import ru.yandex.tours.hotels.{HotelIO, HotelsUtil}
import ru.yandex.tours.model.BaseModel.LangToVal
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel

import scala.collection.JavaConversions._

object LangFixer extends App {
  val hotels = HotelIO.loadFromFileAsIterator(new File("hotel_with_types.proto"))
  val russianLetters = "абвгдеёжзийклмнопрстуфхцчшщьыъэюя".toSet
  def fixLang(x: LangToVal): LangToVal = {
    if (x.getLang == "other") {
      val lang = if (x.getValue.exists(russianLetters.contains)) {
        "ru"
      } else {
        "en"
      }
      LangToVal.newBuilder().setLang(lang).setValue(x.getValue).build()
    } else {
      x
    }
  }

  def fixLang(hotel: Hotel.Builder) {
    val names = hotel.getNameList.map(fixLang)
    hotel.clearName().addAllName(names)
  }

  val os = new FileOutputStream("lang_fixed.proto")
  HotelsUtil.updateHotels(hotels, fixLang).foreach(_.writeDelimitedTo(os))
  os.close()
}
