package ru.yandex.tours.tools.hotels

import java.io.{FileOutputStream, File}

import ru.yandex.tours.hotels.{HotelsUtil, HotelIO}
import ru.yandex.tours.model.Image
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.parsing.Tabbed
import scala.collection.JavaConversions._

object PhotoCorrectorTool extends App {
  val hotels = HotelIO.loadFromFileAsIterator(new File("booking_features_updated.proto"))
  val firstImage = scala.io.Source.fromFile(new File("ostrovok_id_2_first_photo.tsv")).getLines().map {
    case Tabbed(id, url) => id -> Image.name(url)
  }.toMap

  var corrected = 0

  def update(builder: Hotel.Builder) = {
    if (builder.getPartnerId == Partners.ostrovok.id && firstImage.contains(builder.getLocalId)) {
      val name = firstImage(builder.getLocalId)
      val images = builder.getImagesList.toList
      images.find(_.getName == name).foreach { photo =>
        if (images.head != photo) {
          corrected += 1
          val finalImages = images.filter(_ != photo) ++ List(photo)
          builder.clearImages().addAllImages(finalImages)
        }
      }
    }
  }

  val os = new FileOutputStream("photo_corrected.proto")
  HotelsUtil.updateHotels(hotels, update).foreach(_.writeDelimitedTo(os))
  println(s"Corrected : $corrected")
  os.close()
}
