package ru.yandex.tours.tools.hotels.hotelindexing

import java.io.File

import ru.yandex.tours.app.{AkkaSupport, Application, DefaultEnvironment, DefaultHttpSupport}
import ru.yandex.tours.avatars.{AvatarClient, HttpAvatarClient, QueuedAvatarClient}
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.db.{DBWrapper, HotelsDbSupport}
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.indexer.hotels._
import ru.yandex.tours.indexer.hotels.feed.StaticPartnerFeedRetriever
import ru.yandex.tours.indexer.hotels.parsers.CommonFormatParser
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.image.ImageProviders
import ru.yandex.tours.parsers.common.DBStableIds
import ru.yandex.tours.resorts.SkiResorts
import ru.yandex.tours.testkit.TestData

import scala.util.{Failure, Success}

trait HotelIndexingTool extends DefaultEnvironment with AkkaSupport with DefaultHttpSupport with TestData {
  app : Application =>

  implicit val ec = akkaSystem.dispatcher

  val partner: Partner
  val imageProvider: ImageProviders.Value
  val regionParam: Option[String]
  val feedFile: File
  val db: DBWrapper

  lazy val hotelsDao = new HotelsDao(db)

  def parser: PartnerHotelParser = new CommonFormatParser(partner, regionParam = regionParam)

  def run(): Unit = {
    val feedRetriever = new StaticPartnerFeedRetriever(feedFile)

    val stableIds = new DBStableIds(db)
    val stableIdEnricher = new StableIdsEnricher(stableIds)

    lazy val avatarClient: AvatarClient = {
      val writeUrl = "http://localhost:8801"
      val readUrl = "http://avatars.mds.yandex.net"
      val httpAvatarClient = new HttpAvatarClient(httpClient, writeUrl, readUrl, "tours")(akkaSystem.dispatcher)
      val queuedClient = new QueuedAvatarClient(httpAvatarClient, 1000)(akkaSystem.dispatcher, akkaSystem)
      queuedClient
    }
    val imageEnricher = new ImageEnricher(avatarClient, shouldDownloadNew = false)(ec, akkaSystem)

    val slopeEnricher = new SlopeDistanceEnricher(Slopes.empty, SkiResorts.empty, Tree.empty)
    val addInfoEnricher = new AddInfoEnricher(slopeEnricher)(akkaSystem, ec)

    val dbUpdater = new PartnerHotelsDbUpdater(hotelsDao)

    val indexer = new PartnerHotelsIndexer(db, hotelsDao, feedRetriever, parser, stableIdEnricher, imageEnricher, addInfoEnricher, dbUpdater, partner, imageProvider)

    indexer.index.onComplete {
      case Success(e) => println(s"success! result in: ${e.getAbsolutePath}")
      case Failure(e) => println("Failed!"); e.printStackTrace()
    }
  }
}
