package ru.yandex.tours.tools.hotels.hotelindexing

import java.io.File

import ru.yandex.tours.app.Application
import ru.yandex.tours.indexer.hotels.PartnerHotelParser
import ru.yandex.tours.indexer.hotels.parsers.CommonFormatParser
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.image.ImageProviders
import ru.yandex.tours.tools.TestDb

/**
  * Created by asoboll on 09.03.16.
  */
object InnaTourIndexingTool extends Application with HotelIndexingTool with TestDb {
  val partner = Partners.inna
  val imageProvider = ImageProviders.inna
  val regionParam = Some("PartnerRegionID")
  val feedFile = new File("inna.hotels.xml")
  val db = testDb

  override def parser: PartnerHotelParser = new CommonFormatParser(partner, regionParam = regionParam)

  run
}
