package ru.yandex.tours.tools.images


import java.io.{File, PrintWriter}
import java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy
import java.util.concurrent.atomic.AtomicInteger
import java.util.concurrent.{ArrayBlockingQueue, ThreadPoolExecutor, TimeUnit}

import akka.util.Timeout
import play.api.libs.json.Json
import ru.yandex.tours.hotels.HotelIO
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.util.http.NingHttpClient
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.JavaConversions._
import scala.concurrent.Await
import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.duration._
import scala.util.control.NonFatal

object GetMetaInfoTool extends App {

  assert(args.length == 2, "1. Hotels proto file 2. Threads number")

  val threadsNumber = args(1).toInt
  val httpClient = new NingHttpClient(None)
  val queue = new ArrayBlockingQueue[Runnable](1000)
  val pool = new ThreadPoolExecutor(threadsNumber, threadsNumber, 10, TimeUnit.MINUTES, queue, new CallerRunsPolicy)

  val downloaded = new AtomicInteger()
  val failed = new AtomicInteger()

  val successLog = new PrintWriter(new File(s"success.meta_image.tsv"))
  val failedLog = new PrintWriter(new File(s"failure.meta_image.tsv"))

  def task(hotel: Hotel) {
    hotel.getImagesList.headOption.foreach{ image =>
      try {
        val url = s"http://localhost:8081/getinfo-tours/${image.getGroup}/${image.getName}/meta"
        val (sc, result) = Await.result(httpClient.get(url)(Timeout(30.seconds)), 30.seconds)
        assert(sc.intValue == 200, s"Non 200 response: $sc: $result")
        val json = Json.parse(result) \ "orig-size"
        successLog.println(Tabbed(image.getName, image.getGroup, (json \ "x").as[Int], (json \ "y").as[Int]))
        successLog.flush()
        val doneCount = downloaded.incrementAndGet()
        if (doneCount % 1000 == 0) {
          println(s"Downloaded: $doneCount. Failed: ${failed.get()}")
        }
      } catch {
        case NonFatal(e) =>
          failedLog.println(Tabbed(image.getName, image.getGroup, e.getMessage))
          failedLog.flush()
          failed.incrementAndGet()
      }
    }
  }

  HotelIO.loadFromFileAsIterator(new File(args(0))).foreach { hotel =>
    pool.submit(new Runnable {
      override def run(): Unit = task(hotel)
    })
  }
}
