package ru.yandex.tours.tools.images

import java.io.{File, FileOutputStream}

import ru.yandex.tours.hotels.{HotelIO, HotelsUtil}
import ru.yandex.tours.model.BaseModel.ProtoImage
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

import scala.collection.JavaConversions._

object MetaInfoApplyTool extends App {
  val map = scala.io.Source.fromFile("success.meta_image.tsv").getLines().map {
    case Tabbed(name,  IntValue(group), IntValue(x), IntValue(y)) =>
      (name, group) -> (x, y)
  }.toMap
  var updated = 0
  def update(builder: Hotel.Builder): Unit = {
    val newImages = builder.getImagesList.toList.map { image =>
      map.get((image.getName, image.getGroup)) match {
        case Some((x, y)) =>
          updated += 1
          val size = ProtoImage.Size.newBuilder().setHeight(y).setWidth(x).build()
          image.toBuilder.setSize(size).build()
        case None => image
      }
    }
    builder.clearImages().addAllImages(newImages)
  }

  val os = new FileOutputStream("meta_updated.proto")
  val hotels = HotelIO.loadFromFileAsIterator(new File("lt_final.proto"))
  HotelsUtil.updateHotels(hotels, update).foreach(_.writeDelimitedTo(os))
  os.close()
  println(s"Images updated: $updated")
}
